<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ServiceControl;

class OrgPolicyViolationInfo extends \Google\Collection
{
  protected $collection_key = 'violationInfo';
  /**
   * @var array[]
   */
  public $payload;
  /**
   * @var string[]
   */
  public $resourceTags;
  /**
   * @var string
   */
  public $resourceType;
  /**
   * @var ViolationInfo[]
   */
  public $violationInfo;
  protected $violationInfoType = ViolationInfo::class;
  protected $violationInfoDataType = 'array';

  /**
   * @param array[]
   */
  public function setPayload($payload)
  {
    $this->payload = $payload;
  }
  /**
   * @return array[]
   */
  public function getPayload()
  {
    return $this->payload;
  }
  /**
   * @param string[]
   */
  public function setResourceTags($resourceTags)
  {
    $this->resourceTags = $resourceTags;
  }
  /**
   * @return string[]
   */
  public function getResourceTags()
  {
    return $this->resourceTags;
  }
  /**
   * @param string
   */
  public function setResourceType($resourceType)
  {
    $this->resourceType = $resourceType;
  }
  /**
   * @return string
   */
  public function getResourceType()
  {
    return $this->resourceType;
  }
  /**
   * @param ViolationInfo[]
   */
  public function setViolationInfo($violationInfo)
  {
    $this->violationInfo = $violationInfo;
  }
  /**
   * @return ViolationInfo[]
   */
  public function getViolationInfo()
  {
    return $this->violationInfo;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(OrgPolicyViolationInfo::class, 'Google_Service_ServiceControl_OrgPolicyViolationInfo');
