<?php
/**
 * This file is part of True Loaded.
 *
 * @link http://www.holbi.co.uk
 * @copyright Copyright (c) 2005 Holbi Group LTD
 *
 * For the full copyright and license information, please view the LICENSE file that was distributed with this source code.
 */

error_reporting(0);
ini_set("display_errors", 0);

define('SETUP_PACKAGE', 'application_files_do_not_unzip.zip');
define('INSTALL_ROOT', dirname(__FILE__));

define('INSTALL_DIR', (strlen($_POST['install_dir']) && valid_folder($_POST['install_dir'])) ? '/' . ltrim(rtrim($_POST['install_dir'], "\\/") . '/', "\\/") : '/');
define('INSTALL_PATH', INSTALL_ROOT . INSTALL_DIR);

if (!isset($_GET['step'])) {
    $content = step1();
} else {
    if (function_exists($_GET['step'])) {
        $function = $_GET['step'];
        $content = $function();
    }
}

function step1() {
    $phpcheckdata = checkParams();
    if (!do_match_absreq()) {
        $content .='<div style="margin-top: 10px; padding: 0pt 0.7em;" class="ui-state-error ui-corner-all">
                        <p>Your Server does not fulfill the requirements needed to unpack the Installation Package. Please unpack the File "' . SETUP_PACKAGE . '" on your local computer and upload it via FTP. After that, open the file "index.php" of the Site Root-Folder in your Browser.</p>
                    </div>';
    }
    $content .= '
		<table class="tableWrap" style="border-collapse: collapse; width: 100%">
                    <thead class="ui-state-default">
                    <tr>
                        <th width="54%">Name</th>
                        <th width="19%">Installed</th>
                        <th width="19%">Required</th>
                        <th width="6%"></th>
                    </tr>
                    </thead>
                    <tbody>';
    $okicon = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAANCAYAAACgu+4kAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoV2luZG93cykiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6RUFERTlDMjk0NkM2MTFFN0E5QkNFNTdFQzlBQTc2QTYiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6RUFERTlDMkE0NkM2MTFFN0E5QkNFNTdFQzlBQTc2QTYiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDpFQURFOUMyNzQ2QzYxMUU3QTlCQ0U1N0VDOUFBNzZBNiIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDpFQURFOUMyODQ2QzYxMUU3QTlCQ0U1N0VDOUFBNzZBNiIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PsMZOJsAAACrSURBVHjaYvj//z8DqVhks7YgjM3EQCIQ3aKzCki9A9LlID4jyBQSNYciCaUTbQAWzSBwFmwAUFIQyEkD4lmvfa68J1IzSJ0JIyhAgIwzQKwExPdAgsiG4NMMVHcPFIi7oZoZoPQZqIsIagZxWKACyABmyFlCmkEA5IIwIN6DxRCCmsEGQP2LzRCCmmEuYCBgCE7NcAPwGIJXM9aUCI2BVdBwcMWnGQQAAgwA/06Kt9+Gd/wAAAAASUVORK5CYII=";
    $failicon = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA0AAAANCAYAAABy6+R8AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoV2luZG93cykiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6MENCODFEM0I0NkM3MTFFN0I1QTdGOUE4MkM5MDc4MEQiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6MENCODFEM0M0NkM3MTFFN0I1QTdGOUE4MkM5MDc4MEQiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDowQ0I4MUQzOTQ2QzcxMUU3QjVBN0Y5QTgyQzkwNzgwRCIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDowQ0I4MUQzQTQ2QzcxMUU3QjVBN0Y5QTgyQzkwNzgwRCIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Pj5wCcsAAADJSURBVHjahJLREYMgDIbR6wI6Qc9ZeNABZBU6go7QFdoBfLCr9NoJygj0D5d4OYo2dzFA/Ej4wcQYDfmr7zsZ557nagN7D8MN4Yk4mcyw5jm3whtaqzG4Io78j9cgAzK3cNrcVCj9QWyyAjM8KEBbe8LH8Q4a9KZs7rwsoaKDoQ1bAEvAPbVHEPdP4PoPSEKoxFGVTk+kvVGUObALqs2i3h4QCtUTuCe5Y6gkTlvznfwcGv5Q8HZ/JLm8LU8VqdXCu7Ocm2TtK8AAq/CN1aFVwHcAAAAASUVORK5CYII=";
    foreach ($phpcheckdata as $fname => $fdata) {
        if (isset($fdata['adviced_fail'])) {
            $passfail_color = ($fdata['adviced_fail']) ? 'neutral' : (($fdata['passfail']) ? 'positive' : 'negative');
            $passfail_icon = ($fdata['adviced_fail']) ? 'style/warn.png' : (($fdata['passfail']) ? $okicon : $failicon);
        } else {
            $passfail_color = ($fdata['passfail']) ? 'positive' : 'negative';
            $passfail_icon = (($fdata['passfail']) ? $okicon : $failicon);
        }
        $content .= '<tr>
                        <td>' . $fdata['name'] . '</td>
                        <td class="' . $passfail_color . '">' . $fdata['installed'] . '</td>
                        <td class="positive">' . $fdata['required'] . '</td>
                        <td><img src="' . $passfail_icon . '" alt="passfail" /></td>
                    </tr>';
    }
    $content .='</tbody>
                </table>
                <br />
                <table width="100%" border="0" cellspacing="1" cellpadding="2">
                    <tr>
                        <td align="right" style="background: #fff8eb; vertical-align: middle;"><span style="font-weight: 500;">Destination Folder<span><br/><span style="font-weight: 300;">(select destination folder for osCommerce)<span></td>
                        <td style="background: #fff8eb;"><input type="text" name="install_dir" size="25" value="' . INSTALL_DIR . '" class="input" style="width: 95%;" /></td>
                    </tr>
		</table>';
    $button = (do_match_req()) ? 'Next' : 'Check again';
    $next_step = (do_match_req()) ? 'step2' : 'step1';
    return array('content' => $content, 'button' => $button, 'next_step' => $next_step);
}

function checkParams() {
    return array(
        'php' => array(
            'name' => 'PHP-Version',
            'required' => '7.4.0+',
            'installed' => phpversion(),
            'passfail' => (phpversion() >= '7.4.0') ? true : false,
        ),
        'zLib' => array(
            'name' => 'Zip-Functions',
            'required' => 'Yes',
            'installed' => (function_exists('zip_open')) ? 'Yes' : 'No',
            'passfail' => (function_exists('zip_open')) ? true : false,
        ),
        'setupfile' => array(
            'name' => 'Setup-Package',
            'required' => 'Yes',
            'installed' => (file_exists(SETUP_PACKAGE)) ? 'Yes' : 'No',
            'passfail' => (file_exists(SETUP_PACKAGE)) ? true : false,
            'ignore_asb' => true,
        ),
        'writable' => array(
            'name' => 'Directory Writable',
            'required' => 'Yes',
            'installed' => (checkWritable()) ? 'Yes' : 'No',
            'passfail' => (checkWritable()) ? true : false,
            'ignore_asb' => true,
        ),
    );
}

function do_match_req() {
    $allmatched_req = true;
    foreach (checkParams() as $fname => $fdata) {
        $allmatched_req = ($fdata['passfail'] || $fdata['ignore']) ? $allmatched_req : false;
    }
    return $allmatched_req;
}

function do_match_absreq() {
    $allmatched_req = true;
    foreach (checkParams() as $fname => $fdata) {
        $allmatched_req = ($fdata['passfail'] || $fdata['ignore_asb']) ? $allmatched_req : false;
    }
    return $allmatched_req;
}

function checkWritable() {
    $folder = INSTALL_ROOT . DIRECTORY_SEPARATOR . 'tmp' . DIRECTORY_SEPARATOR;
    @mkdir($folder, 0755);
    @chmod($folder, 0755);
    if (@file_exists($folder)) {
        if (!( $f = @fopen($folder . 'tmp.php', 'wb'))) {
            return false;
        }
        @fwrite($f, 'Trueloaded');
        @fclose($f);
        if (!@file_exists($folder . 'tmp.php') || (@file_get_contents($folder . 'tmp.php') != "Trueloaded")) {
            return false;
        }
        @unlink($folder . 'tmp.php');
        if (@file_exists($folder . 'tmp.php')) {
            return false;
        }
        @rmdir($folder);
        return true;
    } else {
        return false;
    }
}

function valid_folder($path) {
    $ignore = array('.', '..', '.svn', 'CVS', 'cache', 'install', 'index.html', '.htaccess', '_images', 'libraries.php');
    if (isset($path)) {
        if (!in_array(basename($path), $ignore) && !is_file($path) && !@is_link($path)) {
            return true;
        }
    }
    return false;
}

function step2() {
    $loadingicon = 'data:image/gif;base64,R0lGODlhIAAgAPMAAP///wAAAMbGxoSEhLa2tpqamjY2NlZWVtjY2OTk5Ly8vB4eHgQEBAAAAAAAAAAAACH/C05FVFNDQVBFMi4wAwEAAAAh/hpDcmVhdGVkIHdpdGggYWpheGxvYWQuaW5mbwAh+QQJCgAAACwAAAAAIAAgAAAE5xDISWlhperN52JLhSSdRgwVo1ICQZRUsiwHpTJT4iowNS8vyW2icCF6k8HMMBkCEDskxTBDAZwuAkkqIfxIQyhBQBFvAQSDITM5VDW6XNE4KagNh6Bgwe60smQUB3d4Rz1ZBApnFASDd0hihh12BkE9kjAJVlycXIg7CQIFA6SlnJ87paqbSKiKoqusnbMdmDC2tXQlkUhziYtyWTxIfy6BE8WJt5YJvpJivxNaGmLHT0VnOgSYf0dZXS7APdpB309RnHOG5gDqXGLDaC457D1zZ/V/nmOM82XiHRLYKhKP1oZmADdEAAAh+QQJCgAAACwAAAAAIAAgAAAE6hDISWlZpOrNp1lGNRSdRpDUolIGw5RUYhhHukqFu8DsrEyqnWThGvAmhVlteBvojpTDDBUEIFwMFBRAmBkSgOrBFZogCASwBDEY/CZSg7GSE0gSCjQBMVG023xWBhklAnoEdhQEfyNqMIcKjhRsjEdnezB+A4k8gTwJhFuiW4dokXiloUepBAp5qaKpp6+Ho7aWW54wl7obvEe0kRuoplCGepwSx2jJvqHEmGt6whJpGpfJCHmOoNHKaHx61WiSR92E4lbFoq+B6QDtuetcaBPnW6+O7wDHpIiK9SaVK5GgV543tzjgGcghAgAh+QQJCgAAACwAAAAAIAAgAAAE7hDISSkxpOrN5zFHNWRdhSiVoVLHspRUMoyUakyEe8PTPCATW9A14E0UvuAKMNAZKYUZCiBMuBakSQKG8G2FzUWox2AUtAQFcBKlVQoLgQReZhQlCIJesQXI5B0CBnUMOxMCenoCfTCEWBsJColTMANldx15BGs8B5wlCZ9Po6OJkwmRpnqkqnuSrayqfKmqpLajoiW5HJq7FL1Gr2mMMcKUMIiJgIemy7xZtJsTmsM4xHiKv5KMCXqfyUCJEonXPN2rAOIAmsfB3uPoAK++G+w48edZPK+M6hLJpQg484enXIdQFSS1u6UhksENEQAAIfkECQoAAAAsAAAAACAAIAAABOcQyEmpGKLqzWcZRVUQnZYg1aBSh2GUVEIQ2aQOE+G+cD4ntpWkZQj1JIiZIogDFFyHI0UxQwFugMSOFIPJftfVAEoZLBbcLEFhlQiqGp1Vd140AUklUN3eCA51C1EWMzMCezCBBmkxVIVHBWd3HHl9JQOIJSdSnJ0TDKChCwUJjoWMPaGqDKannasMo6WnM562R5YluZRwur0wpgqZE7NKUm+FNRPIhjBJxKZteWuIBMN4zRMIVIhffcgojwCF117i4nlLnY5ztRLsnOk+aV+oJY7V7m76PdkS4trKcdg0Zc0tTcKkRAAAIfkECQoAAAAsAAAAACAAIAAABO4QyEkpKqjqzScpRaVkXZWQEximw1BSCUEIlDohrft6cpKCk5xid5MNJTaAIkekKGQkWyKHkvhKsR7ARmitkAYDYRIbUQRQjWBwJRzChi9CRlBcY1UN4g0/VNB0AlcvcAYHRyZPdEQFYV8ccwR5HWxEJ02YmRMLnJ1xCYp0Y5idpQuhopmmC2KgojKasUQDk5BNAwwMOh2RtRq5uQuPZKGIJQIGwAwGf6I0JXMpC8C7kXWDBINFMxS4DKMAWVWAGYsAdNqW5uaRxkSKJOZKaU3tPOBZ4DuK2LATgJhkPJMgTwKCdFjyPHEnKxFCDhEAACH5BAkKAAAALAAAAAAgACAAAATzEMhJaVKp6s2nIkolIJ2WkBShpkVRWqqQrhLSEu9MZJKK9y1ZrqYK9WiClmvoUaF8gIQSNeF1Er4MNFn4SRSDARWroAIETg1iVwuHjYB1kYc1mwruwXKC9gmsJXliGxc+XiUCby9ydh1sOSdMkpMTBpaXBzsfhoc5l58Gm5yToAaZhaOUqjkDgCWNHAULCwOLaTmzswadEqggQwgHuQsHIoZCHQMMQgQGubVEcxOPFAcMDAYUA85eWARmfSRQCdcMe0zeP1AAygwLlJtPNAAL19DARdPzBOWSm1brJBi45soRAWQAAkrQIykShQ9wVhHCwCQCACH5BAkKAAAALAAAAAAgACAAAATrEMhJaVKp6s2nIkqFZF2VIBWhUsJaTokqUCoBq+E71SRQeyqUToLA7VxF0JDyIQh/MVVPMt1ECZlfcjZJ9mIKoaTl1MRIl5o4CUKXOwmyrCInCKqcWtvadL2SYhyASyNDJ0uIiRMDjI0Fd30/iI2UA5GSS5UDj2l6NoqgOgN4gksEBgYFf0FDqKgHnyZ9OX8HrgYHdHpcHQULXAS2qKpENRg7eAMLC7kTBaixUYFkKAzWAAnLC7FLVxLWDBLKCwaKTULgEwbLA4hJtOkSBNqITT3xEgfLpBtzE/jiuL04RGEBgwWhShRgQExHBAAh+QQJCgAAACwAAAAAIAAgAAAE7xDISWlSqerNpyJKhWRdlSAVoVLCWk6JKlAqAavhO9UkUHsqlE6CwO1cRdCQ8iEIfzFVTzLdRAmZX3I2SfZiCqGk5dTESJeaOAlClzsJsqwiJwiqnFrb2nS9kmIcgEsjQydLiIlHehhpejaIjzh9eomSjZR+ipslWIRLAgMDOR2DOqKogTB9pCUJBagDBXR6XB0EBkIIsaRsGGMMAxoDBgYHTKJiUYEGDAzHC9EACcUGkIgFzgwZ0QsSBcXHiQvOwgDdEwfFs0sDzt4S6BK4xYjkDOzn0unFeBzOBijIm1Dgmg5YFQwsCMjp1oJ8LyIAACH5BAkKAAAALAAAAAAgACAAAATwEMhJaVKp6s2nIkqFZF2VIBWhUsJaTokqUCoBq+E71SRQeyqUToLA7VxF0JDyIQh/MVVPMt1ECZlfcjZJ9mIKoaTl1MRIl5o4CUKXOwmyrCInCKqcWtvadL2SYhyASyNDJ0uIiUd6GGl6NoiPOH16iZKNlH6KmyWFOggHhEEvAwwMA0N9GBsEC6amhnVcEwavDAazGwIDaH1ipaYLBUTCGgQDA8NdHz0FpqgTBwsLqAbWAAnIA4FWKdMLGdYGEgraigbT0OITBcg5QwPT4xLrROZL6AuQAPUS7bxLpoWidY0JtxLHKhwwMJBTHgPKdEQAACH5BAkKAAAALAAAAAAgACAAAATrEMhJaVKp6s2nIkqFZF2VIBWhUsJaTokqUCoBq+E71SRQeyqUToLA7VxF0JDyIQh/MVVPMt1ECZlfcjZJ9mIKoaTl1MRIl5o4CUKXOwmyrCInCKqcWtvadL2SYhyASyNDJ0uIiUd6GAULDJCRiXo1CpGXDJOUjY+Yip9DhToJA4RBLwMLCwVDfRgbBAaqqoZ1XBMHswsHtxtFaH1iqaoGNgAIxRpbFAgfPQSqpbgGBqUD1wBXeCYp1AYZ19JJOYgH1KwA4UBvQwXUBxPqVD9L3sbp2BNk2xvvFPJd+MFCN6HAAIKgNggY0KtEBAAh+QQJCgAAACwAAAAAIAAgAAAE6BDISWlSqerNpyJKhWRdlSAVoVLCWk6JKlAqAavhO9UkUHsqlE6CwO1cRdCQ8iEIfzFVTzLdRAmZX3I2SfYIDMaAFdTESJeaEDAIMxYFqrOUaNW4E4ObYcCXaiBVEgULe0NJaxxtYksjh2NLkZISgDgJhHthkpU4mW6blRiYmZOlh4JWkDqILwUGBnE6TYEbCgevr0N1gH4At7gHiRpFaLNrrq8HNgAJA70AWxQIH1+vsYMDAzZQPC9VCNkDWUhGkuE5PxJNwiUK4UfLzOlD4WvzAHaoG9nxPi5d+jYUqfAhhykOFwJWiAAAIfkECQoAAAAsAAAAACAAIAAABPAQyElpUqnqzaciSoVkXVUMFaFSwlpOCcMYlErAavhOMnNLNo8KsZsMZItJEIDIFSkLGQoQTNhIsFehRww2CQLKF0tYGKYSg+ygsZIuNqJksKgbfgIGepNo2cIUB3V1B3IvNiBYNQaDSTtfhhx0CwVPI0UJe0+bm4g5VgcGoqOcnjmjqDSdnhgEoamcsZuXO1aWQy8KAwOAuTYYGwi7w5h+Kr0SJ8MFihpNbx+4Erq7BYBuzsdiH1jCAzoSfl0rVirNbRXlBBlLX+BP0XJLAPGzTkAuAOqb0WT5AH7OcdCm5B8TgRwSRKIHQtaLCwg1RAAAOwAAAAAAAAAAAA==';
    $content = '<br /><img src="' . $loadingicon . '" style="vertical-align:middle;"/> Unpacking ...';
    $js = '$(document).ready(function(){
	    $("#submit_button").attr( "disabled", "disabled" );
		$.post("?step=ajax_unpack", { install_dir: "' . INSTALL_DIR . '"},
  	        function(data) {
			    if (data == "true"){
				    $("#submit_button").removeAttr("disabled");
				    window.location.href = ".' . INSTALL_DIR . 'install/";
                } else {
                    $("#content").html(\'<p style="color: red">\' + data);
                }
		    });
		});
	';
    return array('content' => $content/*, 'button' => 'Install'*/, 'next_step' => '', 'js' => $js);
}

function _symlink( $target, $link ) {
  if ($_SERVER['WINDIR'] || $_SERVER['windir']) {
    exec('junction "' . $link . '" "' . $target . '"');
  } else {
    symlink($target,$link);
  }
}

function ajax_unpack() {
    try {
        // fix for windows: unlink works but unzipping index.php fails
        $fnIndex = INSTALL_ROOT . '/index.php';
        $fnIndexNew = INSTALL_ROOT . '/index_old.php';
        if (rename($fnIndex, $fnIndexNew)) {
            $fnIndex = $fnIndexNew;
        }
        @unlink($fnIndex);
        extractZip(INSTALL_ROOT . DIRECTORY_SEPARATOR . SETUP_PACKAGE);
        _symlink(INSTALL_ROOT, INSTALL_ROOT . DIRECTORY_SEPARATOR . 'watch');
        _symlink(INSTALL_ROOT, INSTALL_ROOT . DIRECTORY_SEPARATOR . 'furniture');
        _symlink(INSTALL_ROOT, INSTALL_ROOT . DIRECTORY_SEPARATOR . 'b2b-supermarket');
        _symlink(INSTALL_ROOT, INSTALL_ROOT . DIRECTORY_SEPARATOR . 'printshop');
        echo "true";
        @unlink(INSTALL_ROOT . DIRECTORY_SEPARATOR . SETUP_PACKAGE);
    } catch (\Exception $e) {
        error_log('!!! ' .$e->getMessage() );
        echo $e->getMessage();
    }
    die();
}

function getLastError() {
    $lastError = error_get_last();
    return !empty($lastError['message']) ? $lastError['message'] : 'unknown reason';
}

function errorClear() {
    if (PHP_VERSION_ID >= 70000) error_clear_last();
}

function extractZip($zipFile = '', $dirFromZip = '') {
    @set_time_limit(0);
    $zipDir = INSTALL_PATH . $dirFromZip;
    $zip = zip_open($zipFile);
    if ($zip) {
        while ($zip_entry = zip_read($zip)) {
            $completePath = $zipDir . dirname(zip_entry_name($zip_entry));
            $completeName = $zipDir . zip_entry_name($zip_entry);
            if (!file_exists($completePath) && preg_match('#^' . $dirFromZip . '.*#', dirname(zip_entry_name($zip_entry)))) {
                $tmp = '';
                foreach (explode('/', $completePath) AS $k) {
                    $tmp .= $k . '/';
                    if (!file_exists($tmp)) {
                        if (PHP_VERSION_ID >= 70000) error_clear_last();
                        if (!mkdir($tmp, 0755) && !is_dir($tmp)) {
                            throw new \Exception("Can not create folder '$tmp': " . getLastError());
                        }
                    }
                }
            }
            if (zip_entry_open($zip, $zip_entry, "r")) {
                if (preg_match('#^' . $dirFromZip . '.*#', dirname(zip_entry_name($zip_entry)))) {
                    if ($fd = @fopen($completeName, 'w+')) {
                        $zip_entry_size = zip_entry_filesize($zip_entry);
                        $entry = zip_entry_read($zip_entry, $zip_entry_size);
                        errorClear();
                        $written = fwrite($fd, $entry);
                        if ($zip_entry_size !== $written) {
                            throw new \Exception("Error while writing file '$completeName' (written $written bytes of $zip_entry_size): " . getLastError());
                        }
                        fclose($fd);
                    } else {
                        errorClear();
                        if (!mkdir($completeName, 0755) && !is_dir($completeName) && substr($completeName, -1) == '/') {
                            throw new \Exception("Can not create folder '$completeName': " . getLastError());
                        }
                    }
                    zip_entry_close($zip_entry);
                }
            }
        }
        zip_close($zip);
    }
    return true;
}
?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
    <head>
        <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
        <link rel="shortcut icon" href="data:image/png;base64,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" type="image/x-icon" />
        <link rel="stylesheet" type="text/css" media="screen" href="https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.11/themes/base/jquery-ui.css" />
        <script type="text/javascript" language="javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.5.1/jquery.min.js"></script>
        <script type="text/javascript" language="javascript" src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.11/jquery-ui.min.js"></script>
        <style type="text/css">
            @import url('//fonts.googleapis.com/css?family=Montserrat:300,400,500,600,700');

            body {
                font-family: 'Montserrat';
                background: #665cac;
                font-size: 12px;
                color: #fff;
                padding:0;
                margin:0;
            }
            #header {
                margin: 0 auto;
                max-width: 820px;
                width: 100%;
            }
            #logo {
                background-image: url('data:image/png;base64,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');
                background-repeat: no-repeat;
                height: 56px;
                width:360px;
                margin: 80px auto 10px;
            }
            #logotext{
              color: #fff;
              font-size: 16px;
              margin: -33px 0 15px;
            }
            #languageselect{
                float: right;
                width: 300px;
                margin-top: 14px;
                padding-right: 20px;
                text-align:right;
                color: white;
            }
            #installer{
                background-color: #ffffff;
                margin: 0 auto;
                width: 820px;
                border: 1px solid #ececec;
                -webkit-box-shadow: 0px 1px 1px 0px rgba(214, 214, 214, 0.35);
                -moz-box-shadow: 0px 1px 1px 0px rgba(214, 214, 214, 0.35);
                box-shadow: 0px 1px 1px 0px rgba(214, 214, 214, 0.35);
            }
            #main{
                font-size: 12px;
            }
            #steps, #content{
                padding:20px;
            }

            #footer {
                clear: right;
                color: #fff;
                font-size: 12px;
                padding: 20px 0;
                text-align: center;
            }
            #footer a{
                color: #fff;
                text-decoration: none;
            }
            #footer a:hover{
                text-decoration: underline;
            }
            .install_label {
                position: absolute;
                width: 90%;
                text-align: center;
                line-height: 1.9em;
                left:5%;
                right:5%;
            }
            select, textarea, input[type="text"], input[type="password"], input[type="datetime"], input[type="datetime-local"], input[type="date"], input[type="month"], input[type="time"], input[type="week"], input[type="number"], input[type="email"], input[type="url"], input[type="search"], input[type="tel"], input[type="color"], .uneditable-input {
                border-radius: 2px 2px 2px 2px;
                color: #555555;
                font-size: 13px;
                line-height: 20px;
                padding: 4px 6px;
                vertical-align: middle;
                background-color: #FFFFFF;
                border: 1px solid #CCCCCC;
                box-shadow: 0 1px 1px rgba(0, 0, 0, 0.075) inset;
                transition: border 0.2s linear 0s, box-shadow 0.2s linear 0s;
                margin: 3px;
            }
            select:focus, textarea:focus, input:focus {
                border-color: rgba(82, 168, 236, 0.8);
                box-shadow: 0 1px 1px rgba(0, 0, 0, 0.075) inset, 0 0 8px rgba(82, 168, 236, 0.6);
                outline: 0 none;
            }
            input[type=radio], input[type=checkbox]{
                background:none;
                border: none;
            }
            h1 {
                font-size: 24px;
                color: #3c3b3b;
                text-align: center;
                font-weight: 500;
                padding: 0;
                margin: 0 0 15px;
                font-weight: 500;
            }
            .buttonbar{
                margin: 15px 10px 0px 0px;
                text-align: center;
            }
            .positive{
                color: #665cac!important;
                font-weight: 500;
                font-size: 14px;
            }
            .negative{
                color: #e11010!important;
                font-weight: bold;
                font-weight: 500;
                font-size: 14px;
            }
            .neutral{
                color: orange;
                font-weight: bold;
            }
            th, td {
                padding: 0.25em 0.5em;

            }
            th{
                font-size: 12px;
                text-align: left;
                font-weight: bold;
            }
            td{
                font-size: 13px;
            }
            .ui-widget-content tr.ui-state-highlight{
                border:0;
            }
            .subname{
                font-weight: normal;
                font-size: 10px;
                font-style: italic;
            }
            .button, input[type="submit"], input[type="button"], input[type="reset"], button{
                display: inline-block;
                zoom: 1; /* zoom and *display = ie7 hack for display:inline-block */
                *display: inline;
                vertical-align: baseline;
                margin: 0 2px;
                outline: none;
                cursor: pointer !important;
                text-align: center;
                text-decoration: none;
                font-size: 14px;
                padding: 5px 5px;
                -webkit-border-radius: 4px;
                -moz-border-radius: 4px;
                border-radius: 4px;
            }
            .button:hover, input[type="submit"]:hover, input[type="button"]:hover , input[type="reset"]:hover, button:hover{
                text-decoration: none;
            }
            .button:active, input[type="submit"]:active, input[type="button"]:active, input[type="reset"]:active, button:active{
                position: relative;
            }
            .bigrounded {
                -webkit-border-radius: 2em;
                -moz-border-radius: 2em;
                border-radius: 2em;
            }
            .medium, .button, input[type="submit"], input[type="button"],input[type="reset"], button {
                font-size: 14px;
                font-weight: 500;
                padding: 9px 35px;
            }
            .small {
                font-size: 11px;
            }
            a.blue, a.blue:hover, a.button, a.button:hover {
                color: #d9eef7;
                line-height: 15px;
            }
            .blue, .button, input[type="submit"], input[type="button"], input[type="reset"], button {
                color: #fff;
                border: none;
                background: #7952b3;
                font-weight: 700;
            }
            .blue:hover, .button:hover, input[type="submit"]:hover, input[type="button"]:hover, input[type="reset"]:hover, button:not(.ui-widget):hover {
                color: #fff;
                background: #7952b3;
            }
            .blue:active, .button:hover, input[type="submit"]:active, input[type="button"]:active, input[type="reset"]:active, button:not(.ui-widget):active {
                color: #fff;
                background: rgb(144,154,169);
                background: -moz-linear-gradient(top, rgba(144,154,169,1) 0%, rgba(128,140,156,1) 100%);
                background: -webkit-linear-gradient(top, rgba(144,154,169,1) 0%,rgba(128,140,156,1) 100%);
                background: linear-gradient(to bottom, rgba(144,154,169,1) 0%,rgba(128,140,156,1) 100%);
                filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#909aa9', endColorstr='#808c9c',GradientType=0 );
            }
            #installer table, .debug table {
                border-collapse:collapse;
            }
            #installer th, .debug th{
                font-weight: 400;
                white-space:nowrap;
                text-align:left;
                background: #fff;
            }
            #installer table.no-borders td {
                border: none !important;
            }
            .tableWrap .ui-state-default{
                border-width: 0 0 1px;
                border-bottom: 1px solid #e2e0e0;
            }
            #installer .tableWrap .ui-state-default th{
                color: #858686;
            }
            #installer th, #installer td, .debug th, .debug td {
                line-height: 20px;
                padding: 7px 15px;
                text-align: left;
                vertical-align: top;
                color: #3c3b3b;
                font-weight: 400;
            }
            #installer tr:nth-child(even) td{
                background: #f5f5f5;
            }
            #installer .tableWrap .ui-state-default th:nth-child(3), #installer .tableWrap td:nth-child(3){
                font-weight: 500;
            }
        </style>

        <script type="text/javascript">
            //<![CDATA[
            $(function () {

                $("#progressbar").progressbar({
                    value: 0,
                });
            });

<?php if (isset($content['js'])) echo $content['js']; ?>
            //]]>
        </script>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <title>osCommerce Installation</title>
    </head>

    <body>
        <form action="?step=<?php echo $content['next_step']; ?>" method="post" id="form_install">
            <div id="header">
                <div id="logo"></div>
                <div id="logotext">ZIP-Installer<br/>osCommerce v.4.14.63493</div>
            </div>
            <div id="installer">
                <div id="main">
                    <div id="content">

                        <h1 class="hicon home">Unpacking Installation Files</h1>
<?php echo $content['content'];
if (isset($content['button'])) {
?>
                        <div class="buttonbar">

                            <input id="submit_button" type="submit" class="" name="next" value="<?php echo $content['button']; ?>" />
                        </div>
<?php
}
?>
                    </div>
                </div>
            </div>
            <div id="footer">
                Copyright &copy; 2000 - <?php echo date('Y', time()); ?> <a target="_blank" href="http://www.oscommerce.com">osCommerce Ltd</a> is provided under <a href="https://www.oscommerce.com/legal-policies" target="_blank">Terms and Conditions</a> and this <a href="https://www.oscommerce.com/legal-policies" target="_blank">Disclaimer</a><br>osCommerce the eCommerce Engine Copyright © 2000 – 2024 osCommerce Ltd<br>osCommerce ® is a Trademark owned by Holbi Group Ltd
            </div>
        </form>
    </body>
</html>
