<?php

class HTMLPurifierTest extends HTMLPurifier_Harness
{
    protected $purifier;

    public function testNull()
    {
        $this->assertPurification("Null byte\0", "Null byte");
    }

    public function test_purifyArray()
    {
        $this->assertIdentical(
            $this->purifier->purifyArray(
                array('Good', '<b>Sketchy', 'foo' => '<script>bad</script>')
            ),
            array('Good', '<b>Sketchy</b>', 'foo' => '')
        );

        $this->assertIsA($this->purifier->context, 'array');

    }

    public function test_purifyArray_nested()
    {
        $this->assertIdentical(
            $this->purifier->purifyArray(
                array('Good', '<b>Sketchy', 'foo' => array('bar' => '<script>bad</script>'))
            ),
            array('Good', '<b>Sketchy</b>', 'foo' => array('bar' => ''))
        );
    }

    public function test_purifyArray_empty() {
        $purifiedEmptyArray = $this->purifier->purifyArray(array());
        $this->assertTrue(
            empty($purifiedEmptyArray)
        );
    }

    public function testGetInstance()
    {
        $purifier  = HTMLPurifier::getInstance();
        $purifier2 = HTMLPurifier::getInstance();
        $this->assertReference($purifier, $purifier2);
    }

    public function testMakeAbsolute()
    {
        $this->config->set('URI.Base', 'http://example.com/bar/baz.php');
        $this->config->set('URI.MakeAbsolute', true);
        $this->assertPurification(
            '<a href="foo.txt">Foobar</a>',
            '<a href="http://example.com/bar/foo.txt">Foobar</a>'
        );
    }

    public function testDisableResources()
    {
        $this->config->set('URI.DisableResources', true);
        $this->assertPurification('<img src="foo.jpg" />', '');
    }

    public function test_addFilter_deprecated()
    {
        $this->expectError('HTMLPurifier->addFilter() is deprecated, use configuration directives in the Filter namespace or Filter.Custom');
        generate_mock_once('HTMLPurifier_Filter');
        $this->purifier->addFilter($mock = new HTMLPurifier_FilterMock());
        $mock->expectOnce('preFilter');
        $mock->expectOnce('postFilter');
        $this->purifier->purify('foo');
    }

}

// vim: et sw=4 sts=4
