<?php
/**
 * This file is part of osCommerce ecommerce platform.
 * osCommerce the ecommerce
 *
 * @link https://www.oscommerce.com
 * @copyright Copyright (c) 2000-2022 osCommerce LTD
 *
 * Released under the GNU General Public License
 * For the full copyright and license information, please view the LICENSE.TXT file that was distributed with this source code.
 */

namespace common\models;

use Yii;
use yii\db\ActiveRecord;

class TmpOrders extends ActiveRecord
{
    /**
     * set table name
     * @return string
     */
    public static function tableName()
    {
        return 'tmp_orders';
    }
    
    public function getCustomer()
    {
        return $this->hasOne(Customers::className(), ['customers_id' => 'customers_id']);
    }


    /**
     * one-to-many
     * @return array
     */
    public function getOrdersTotals()
    {
        return $this->hasMany(TmpOrdersTotal::className(), ['orders_id' => 'orders_id'])->orderby('sort_order');
    }

    /**
     * one-to-many
     * @return ActiveQuery
     */
    public function getOrdersStatusHistory()
    {
        return $this->hasMany(TmpOrdersStatusHistory::className(), ['orders_id' => 'orders_id']);
    }

        /**
     * one-to-many
     * @return array
     */
    public function getOrdersProducts()
    {
        return $this->hasMany(TmpOrdersProducts::className(), ['orders_id' => 'orders_id']);
    }

    
}
