<?php

namespace common\classes\Billing;

interface BillingPointInterface
{

    /**
     * @return array
     */
    public static function getSupportedOperations();

    /**
     * @param string $operation 'generate-product-info' / 'translate-product-info'
     * @param string $domainKey domain key generated by installation
     * @param string $appKey AppShop key generated in oscommerce.com
     * @param $extraParams
     * @return void
     */
    public static function checkOperationAvailable(string $operation, string $domainKey, string $appKey, $extraParams = null);

    public static function doOperationFinished(string $operation, string $domainKey, string $appKey, $extraParams = null);

}